; object representing a HANK netCDF file
PRO hank_ncfile__define
    struct = { hank_ncfile,     $   ; class name
               inherits ncfile, $   ; superclass 
               ix:0L,           $   ; 'x' dimension id
               iy:0L,           $   ; 'y' dimension id
               ilev:0L,         $   ; 'lev' dimension id
               ilev_edge:0L,    $   ; 'lev_edge' dimension id
               itime:0L,        $   ; 'time' dimension id
               ; parameters read from global attributes
               dx:0.,           $   ; x bins size (km)
               dy:0.,           $   ; y bins size (km)
               projection:'',   $   ; projection type
               lat0:0L,         $   ; center latitude for projection
               lon0:0L,         $   ; center longitude for projection
               ; missing value for lat/lon points outside of x/y domain
               missing:-1.E36,  $
               ; output variables
               vidsout:ptr_new(), $ ; input id --> output id (or -1)
               ; arrays
               lats:ptr_new(),  $   ; latitudes
               lons:ptr_new(),  $   ; longitudes
               xs:ptr_new(),    $   ; X coordinates of lat/lon grid
               ys:ptr_new(),    $   ; Y coordinates of lat/lon grid
               is:ptr_new(),    $   ; fractional indixes for xs
               js:ptr_new()     $   ; fractional indixes for ys
    }
END
