; method to take difference of two datasets
; data missing values must be substituted with !values.f_nan before calling this method
; NOTE: in IDL: x(finite)/0 = Inf,  0/0 = NaN
FUNCTION operator_difference_percent, ap, bp
  
  ; check for compatibility
  if (operator_check(ap,bp)) then begin

      ; allocate new memory
      cp = ptr_new(*ap) 

      ; check for missing values
      bad_indexes = where((finite(*ap) eq 0) or (finite(*bp) eq 0), nbad)
      if (nbad gt 0) then (*cp)[bad_indexes] = !values.f_nan

      good_indexes = where((finite(*ap) eq 1) and (finite(*bp) eq 1), ngood)
      if (ngood gt 0) then begin
          (*cp)[good_indexes] = ((*ap)[good_indexes] - (*bp)[good_indexes])/(*bp)[good_indexes]
      endif

      return, cp

  endif else return, ptr_new() ; error: return invalid pointer

END
