FUNCTION archive_manager::INIT, data_dirs=data_dirs

  ; parse input data_dirs[] for valid directories
  nvaliddirs=0
  if (keyword_set(data_dirs) and n_elements(data_dirs) gt 0) then begin
      for i=0, n_elements(data_dirs)-1 do begin
          if (data_dirs[i] ne '') then begin
              junk = findfile(data_dirs[i],count=c)
              if (c eq 0) then begin
                  print,'DATA DIRECTORY ',data_dirs[i], ' NOT FOUND'
                  data_dirs[i] = '' ; remove this directory
              endif
          endif
      endfor
      ivaliddirs = where(data_dirs ne '', nvaliddirs)
  endif
  if (nvaliddirs gt 0) then begin
      self.data_dirs = ptr_new(data_dirs[ivaliddirs])
  endif else begin
      cd, '.', current=current_dir
      self.data_dirs = ptr_new([current_dir])
  endelse

  ; superclass constructor --> calls build_gui
;mgs++
;  Only build new GUI if not already registered. Otherwise focus only
  IF xregistered('GEOV_ARCHIVE_MANAGER') GT 0 THEN BEGIN
     ;; set focus (done automatically by xregistered)
     ok = 0
  ENDIF ELSE BEGIN
     geovstring = 'GEOV '+String(!geov_version)
     ok = self->gui::INIT(title=geovstring+' DATA ARCHIVE MANAGER', $
                          registername='GEOV_ARCHIVE_MANAGER', $
                          /column)
    ; to prevent flickering or flashing while gui is being built and
    ; repositioned on screen
     widget_control, self.base_wid, map=1, update=1
  ENDELSE
;mgs--
  return, ok

END
