; method to return a specified number of color indexes 
; equally spaced within the color table
FUNCTION color_manager::get_colors, ncolors

  ; last portion of the table is used for the drawing colors (axis, etc)

  colors = ptr_new(bytarr(ncolors))

;  (*colors)[0] = 0
;  if (ncolors gt 2) then $
;;     (*colors)[1:ncolors-2] = (1+bindgen(ncolors-2))*round( float((!d.table_size-2))/float((ncolors-1)) )
;     (*colors)[1:ncolors-2] = (1+bindgen(ncolors-2))*round( float((!d.table_size-11))/float((ncolors-1)) )
;  if (ncolors gt 1) then $
;     (*colors)[ncolors-1] = !d.table_size-1

  ; this seems to give a better selection of colors 
  ; -- it uses a larger range of the available colors

  if (ncolors gt 3) then $
     (*colors)[1:ncolors-3] = 1+bindgen(ncolors-3)*( float((!d.table_size-12))/float((ncolors-3)) )
  if (ncolors gt 2) then $
     (*colors)[ncolors-2] = !d.table_size-11
  if (ncolors gt 1) then $
     (*colors)[ncolors-1] = !d.table_size-1

  return, colors

END
