; method to export map parameters to mapper object (after basic checking)
FUNCTION gui_mapper::export

   ; map limits and center
   map_limits = self->get_map_limits()
   map_center = self->get_map_center()
   if (map_limits[1] gt map_center[1] or map_center[1] gt map_limits[3] or map_limits[1] lt -180 or map_limits[3] gt 360) then begin
       message,'ERROR: INVALID LONGITUDES'
       return, 1
   endif
   if (map_limits[0] gt map_center[0] or map_center[0] gt map_limits[2] or map_limits[0] lt -90 or map_limits[2] gt 90) then begin
       message,'ERROR: INVALID LATITUDES'
       return, 1
   endif

   ; export
   self.mapper->set_map_limits, map_limits
   self.mapper->set_map_center, map_center
   self.mapper->set_map_projection, self->get_map_projection()
   self.mapper->set_map_flags, self->get_map_flags()

END
