PRO nccoordfile::find_coord
  @nccoord_pars
print,'nccoordfile::find_coord... 0'
  ; loop on variables to identify coordinates
  ; a variable is a coordinate if it depends only on one dimension
  ; and it has the same name as the dimension
  self.ncoords = 0 ; number of coordinates
  for vid=0, self.nvars-1 do begin

    if ((*self.vndims)[vid] eq 1) then begin ; check variable has only 1 dimension

       did = self->get_dimid_of_var(0,vid)
       dname = strlowcase((*self.dnames)[did])
       vname = strlowcase((*self.vnames)[vid])
       vunits = strlowcase((*self.vunits)[vid])
          
       if (dname eq vname) then begin  ; check names are the same

         ; coordinate found!
         (*self.cvars)[self.ncoords] = vid       ; coordinate number --> variable id
         self.ncoords = self.ncoords+1

       endif ; names are the same

    endif ; variable has only 1 dimension

  endfor   ; loop over variables

print,'nccoordfile::find_coord... end'

END
