FUNCTION nccoordfile::init, ncfilename
  @nccoord_pars

  ; precompile access functions
  self->nccoordfile::get

  ; explicit call to superclass constructor
  ok = self->ncfile::init(ncfilename)
  if (ok) then begin

    ; allocate more memory (maximum possible size)
;    self.cdims = ptr_new(lonarr(self.ndims))
    self.cvars = ptr_new(lonarr(self.ndims))
    self.coords= ptr_new(ptrarr(self.ndims))
    self.pvars = ptr_new(lonarr(self.nvars))
    self.d2coord=ptr_new(lonarr(self.ndims)) & (*self.d2coord)[*] = -1
    self.cflags =ptr_new(lonarr(self.ndims))
    self.clabels=ptr_new(strarr(self.ndims))

;    (*self.cdims)[*] = -1

    ; look for coordinates among variables
    self->find_coord ; method must assign self.ncoords, self.cvars

    ; loop over coordinates
    for ic=0, self.ncoords-1 do begin

      vid = (*self.cvars)[ic]

      if vid ge 0 then begin

        nx = n_elements( (*(*self.v2dims)[vid]) ) - 1
;        did = self->get_dimid_of_var(0,vid)
        did = self->get_dimid_of_var(nx,vid)

        vname = (*self.vnames)[vid] 
        vunits =(*self.vunits)[vid] 

;        (*self.cdims)[ic] = did       ; coordinate number --> dimension id
        (*self.d2coord)[did] = ic     ; dimension id --> coordinate number
        NCDF_VARGET, self.fid, vid, data        ; extract coordinate values
        (*self.coords)[ic] = ptr_new(data)

                                ; assign default label for this coordinate 
                                ; (mgs 22 April 2002: changed () to []
        if (vunits ne '') then (*self.clabels)[ic] = string(vname,' [', vunits,']') $
        else                   (*self.clabels)[ic] = vname

        ; check coordinate attributes
        result = NCDF_VARINQ(self.fid,vid)

        for iatt=0,result.natts-1 do begin

            attname = strlowcase(NCDF_ATTNAME(self.fid,vid,iatt)) ; attribute name

            ; check for name=positive value=down
            if (attname eq 'positive') then begin
                NCDF_ATTGET,self.fid,result.name,attname,value
                if (string(value) eq 'down') then (*self.cflags)[ic] = (*self.cflags)[ic] or NCCOORD_FLAG_DOWN
            endif

        endfor
      endif else begin
        did = ic
        (*self.coords)[ic] = ptr_new( indgen((*self.dsizes)[ic]) )
      endelse

    endfor ; loop over coordinates

    ; reduce arrays size according to number of coordinates found
    *self.cdims  =(*self.cdims)[0:self.ncoords-1]
    *self.cvars  =(*self.cvars)[0:self.ncoords-1]
    *self.coords =(*self.coords)[0:self.ncoords-1]
    *self.cflags =(*self.cflags)[0:self.ncoords-1]
    *self.clabels=(*self.clabels)[0:self.ncoords-1]

    ; loop on variables to identify plotting variables
    ; (variables which depend only on coordinates)

    self.npvars = 0  ; number of plot variables

    for vid=0, self.nvars-1 do begin

        vndim=(*self.vndims)[vid]


        if (vndim ge 1) then begin
          indexes = where(*self.cvars eq vid, counts) ; check it's not a coordinate variable
          if (counts eq 0) then begin  ; check it depends only on coordinate dimensions
            acceptit = 1
            for idim=0,vndim-1 do begin
              did = self->get_dimid_of_var(idim,vid)
              indexes = where(*self.cdims eq did, counts)
              if (counts eq 0) then acceptit = 0 ; reject this variable
            endfor
            if (acceptit) then begin
              (*self.pvars)[self.npvars] = vid ; add it to the list
              self.npvars = self.npvars+1
            endif
          endif ; not a coordinate
        endif ; vndim>=1
    endfor

    ; reduce array size
    (*self.pvars) = (*self.pvars)[0:self.npvars-1]

    ; sort variables by name
    indexes = sort( (*self.vnames)[*self.pvars] )

    *self.pvars = (*self.pvars)[indexes]

  endif ; ncfile read succefully

  return, ok

END
