;+
; NAME:
;    MGS_Dummy
;
; PURPOSE:
;    This widget object analyses a structure that is passed to the
;  Init method and builds a widget with one input field per structure
;  tag using the tag value as default (must be scalars). The
;  individual structure tags can be of any numerical or string
;  type. This widget makes it extremely easy to inspect or modify
;  structure values and it demonstrates the power of the MGS_BaseGUI
;  class hierarchy. All input fields are simple MGS_Field objects
;  which are added to the object's compound container. No event
;  handling etc. must be programmed, this is all done within the
;  individual compound widget objects.
;     The GetValue method returns a structure with the new field values.
;
; CATEGORY:
;  Widget Objects
;
; CALLING SEQUENCE:
;    Demo = { Name: 'Martin Schultz', Height: 180.,  $
;             email:'martin.schultz@dkrz.de', phone_ext: 308 }
;    themask = Obj_New('MGS_Dummy', Demo [,keywords])
;    themask->GUI, /block
;    newvalues = themask->GetValue()
;    help, newvalues, /Structure
;    Obj_Destroy, themask
;
;    MGS_inputmask can itself also be used as a compound widget!
;
; ARGUMENTS:
;
; KEYWORDS:
;
; MODIFICATION HISTORY:
;    mgs, 04 Apr 2001: Version 1.0 released
;-
;
;###########################################################################
;
; LICENSE
;
; This software is OSI Certified Open Source Software.
; OSI Certified is a certification mark of the Open Source Initiative.
;
; Copyright  2001 Martin Schultz
;
; This software is provided "as-is", without any express or
; implied warranty. In no event will the authors be held liable
; for any damages arising from the use of this software.
;
; Permission is granted to anyone to use this software for any
; purpose, including commercial applications, and to alter it and
; redistribute it freely, subject to the following restrictions:
;
; 1. The origin of this software must not be misrepresented; you must
;    not claim you wrote the original software. If you use this software
;    in a product, an acknowledgment in the product documentation
;    would be appreciated, but is not required.
;
; 2. Altered source versions must be plainly marked as such, and must
;    not be misrepresented as being the original software.
;
; 3. This notice may not be removed or altered from any source distribution.
;
; For more information on Open Source Software, visit the Open Source
; web site: http://www.opensource.org.
;
;###########################################################################



; -----------------------------------------------------------------------------
; GetState:
;   This method returns the currently selected range as a structure.

FUNCTION MGS_Dummy::GetState

   cw = self.compound->Get(position=1)
   retval = cw->GetState()

   RETURN, retval

END


; -----------------------------------------------------------------------------
; GetValue:
;   This method collects the current values from all fields and stores
; them in a structure.

FUNCTION MGS_Dummy::GetValue

   cw = self.compound->Get(position=1)
   retval = cw->GetValue()

   RETURN, retval

END


PRO MGS_Dummy::BuildGUI

   fieldID = FSC_Field(self.layoutID, value=self.fieldvalue,title='bla',object=o)

END


; -----------------------------------------------------------------------------
; Init:
;   This method initializes the range field object.
; For now, the only fields that need to be specified individually to
; each of the compound field widgets are label and
; value. Alternatively, you can give range as a 2-element vector.
; All other options that are possible for MGS_Field are passed through
; the extra mechanism and will thus apply to both fields.

FUNCTION MGS_Dummy::Init, $
   structure,       $  ; A data structure defining the labels (tag_names) and values
   _Extra=extra  ; Extra keywords from inherited objects
                                ;
                                ; Inherited keywords (from
                                ; MGS_BaseGUI and MGS_BaseObject):
                                ; name      : The object name
                                ; no_copy   : Don't retain a copy
                                ;             of uvalue
                                ; no_dialog : Don't display
                                ;             interactive dialogs
                                ; uvalue    : a user-defined value
                                ; window_title
                                ; widget_title
                                ; row_layout (ignored)
                                ; no_frame (ignored)
                                ; widget_defaultfont
                                ; widget_labelfont
                                ; set_value_pro
                                ; get_value_func


   ;; Initialize parent object
   IF not self->MGS_BaseGUI::Init(_Extra=extra) THEN RETURN, 0

   ;; Error Handler
   Catch, theError
   IF theError NE 0 THEN BEGIN
      self->ErrorMessage, 'Error initialising object'
      RETURN, 0
   ENDIF

   ;; Check keywords and parameters.
   IF ChkStru(structure) EQ 0 THEN BEGIN
      self->ErrorMessage, 'A data structure is mandatory'
      RETURN, 0
   ENDIF

   ;; Create compound widget objects (text fields)
   self.fieldvalue = 'David Fanning'

   ;; Reset some of the generic default properties
   IF self.window_title EQ 'Generic widget object' THEN $
      self.window_title = 'Input mask'

   ;; Set layout to row
   self.column_layout = 1

   self.layout_frame = 1    ;; Put a frame around this widget

   RETURN, 1
END


; -----------------------------------------------------------------------------
; MGS_Dummy__Define:
; This is the object definition for the input mask object.
; It inherits from MGS_BaseGUI which provides the generic widget
; functionality, and from MGS_BaseObject the abilities to set and
; query an object name and a uvalue. The base object also provides a
; general method for display of error messages which can be directed
; to a message dialog or to the log screen via the no_dialog flag.

PRO MGS_Dummy__Define

   struct = { MGS_Dummy, $
              fieldvalue:'', $
              inherits MGS_BaseGUI  }

END


; -----------------------------------------------------------------------------
; Example:
;    Demonstrate the functionality of this object

PRO Example, structure, block=block, object=object, _EXTRA=extra

   IF N_Elements(structure) EQ 0 THEN $
      structure = { Name: 'Martin Schultz', Height: 180.,  $
               email:'martin.schultz@dkrz.de', phone_ext: 308 }

   thegui = Obj_New('MGS_Dummy', structure, _Extra=extra)
   thegui->GUI, block=keyword_Set(block)
   keywords = thegui->GetState()
   help, keywords, /structure
   IF Arg_Present(object) EQ 0 THEN Obj_Destroy, thegui ELSE object=thegui

END
