



PRO test_regrid, oldgridname, newgridname, result=result, debug=debug


   oldgrid = Obj_New('MGS_RGrid', gridname=oldgridname, $
                     select=(N_Elements(oldgridname) EQ 0) )

   newgrid = Obj_New('MGS_RGrid', gridname=newgridname, $
                     select=(N_Elements(newgridname) EQ 0) )


   ;; create data array with all 1's
   oldgrid->GetProperty, nlon=nlon, nlat=nlat
   data = fltarr(nlon, nlat)+1.

   ;; Set debug level to 3 in order to see something
   newgrid->SetProperty, debug=debug
   oldgrid->SetProperty, debug=debug

   ;; Do the regridding
   result = newgrid->Regrid(data, oldgrid)

   ;; Destroy the objects
   Obj_Destroy, oldgrid
   Obj_Destroy, newgrid

END
